	 function [k, c, alfa] = GRAY_MARKEL_2(G, Z, P)
	 
	 %	Computes the reflection coefficients, k, weigths, c, and 
	 %	noise gains, alfa, for a two-multipler Gray and Markel structure
	 %
	 % 	Toolbox for DIGITAL FILTERS USING MATLAB 
	 
	 % 	Author: 		Lars Wanhammar 2011-02-11
	 % 	Modified by: 	 
	 % 	Copyright:		by authors - not released for commercial use
	 % 	Version:		1
	 % 	Known bugs:		 
	 % 	Report bugs to:	Wanhammar@gmail.com
	 
	 Denum = real( ZEROS_2_POLY(P));
	 Num = G*real(ZEROS_2_POLY(Z));
	 N = length(P);
	 k = zeros(N, 1); 
	 alfa(N+1) = 1;
	 k(N-1) = Denum(end);
	 c(N+1) = Num(end);
	 for m = N:-1:1	
		 B = fliplr(Denum);
		 k(m) = Denum(end);
		 x = 1 - k(m)^2;
		 Denum = (Denum - k(m)*B)/x;
		 c(m+1) = Num(end);
		 Num = Num - c(m+1)*B;
		 alfa(m) = alfa(m+1)/x;
		 Denum(end) = [];
		 Num(end) = [];
	 end	
	 c(1) = Num(end);
	 c = c';
	 alfa = alfa';
